
/*
 * winh.h:
 *      header file for winh.h, which contains Presentation Manager
 *      helper functions that are  independent of a single application,
 *      i.e. these can be  used w/out the rest of the XFolder source in
 *      any PM program.
 *
 *      Copyright (C) 1997-99 Ulrich Mller.
 *      This file is part of the XFolder source package.
 *      XFolder is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published
 *      by the Free Software Foundation, in version 2 as it comes in the
 *      "COPYING" file of the XFolder main distribution.
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 */

#if __cplusplus
extern "C" {
#endif

#ifndef WINH_HEADER_INCLUDED
    #define WINH_HEADER_INCLUDED

    /*
     *  Here come some monster macros for
     *  frequently needed functions.
     */

    #define DebugBox(title, text) \
             WinMessageBox(HWND_DESKTOP, HWND_DESKTOP,   \
                (PSZ)text, (PSZ)title,    \
                0, MB_OK | MB_ICONEXCLAMATION | MB_MOVEABLE)

    #define YesNoBox(title, text) \
             WinMessageBox(HWND_DESKTOP, HWND_DESKTOP,   \
                (PSZ)text, (PSZ)title,    \
                0, MB_YESNO | MB_ICONQUESTION | MB_MOVEABLE)

    #define MPNULL                 (MPFROMP(NULL))
    #define MPZERO                 (MPFROMSHORT(0))
    #define MRTRUE                 (MRFROMSHORT((SHORT) TRUE))
    #define MRFALSE                (MRFROMSHORT((SHORT) FALSE))
    #define BM_UNCHECKED           0   // for checkboxes: disabled
    #define BM_CHECKED             1   // for checkboses: enabled
    #define BM_INDETERMINATE       2   // for tri-state checkboxes: indeterminate

    #define winhSetDlgItemChecked(hwnd, id, bCheck) \
            WinSendDlgItemMsg(hwnd, id, BM_SETCHECK, MPFROMSHORT(bCheck), MPNULL)

    #define winhIsDlgItemChecked(hwnd, id) \
            (SHORT1FROMMR(WinSendDlgItemMsg((hwnd), (id), BM_QUERYCHECK, MPNULL, MPNULL)))

    #define winhSetMenuItemChecked(hwndMenu, usId, bCheck) \
            WinSendMsg(hwndMenu, MM_SETITEMATTR, MPFROM2SHORT(usId, TRUE), \
                    MPFROM2SHORT(MIA_CHECKED, ((bCheck) ? MIA_CHECKED : FALSE)))

    #define winhShowDlgItem(hwnd, id, show) \
            WinShowWindow(WinWindowFromID(hwnd, id), show)

    #define winhSetWindowFont(hwnd, szFont)\
            (WinSetPresParam(hwnd),\
            PP_FONTNAMESIZE, (ULONG)strlen(szFont)+1, szFont))

    #define winhSetDlgItemFont(hwnd, usId, szFont)\
            (WinSetPresParam(WinWindowFromID(hwnd, usId),\
            PP_FONTNAMESIZE, (ULONG)strlen(szFont)+1, szFont))

    #define winhEnableDlgItem(hwndDlg, ulId, Enable) \
            WinEnableWindow(WinWindowFromID(hwndDlg, ulId), Enable)

    #define winhIsDlgItemEnabled(hwndDlg, ulId) \
            WinIsWindowEnabled(WinWindowFromID(hwndDlg, ulId))

    #define winhSetDlgItemFocus(hwndDlg, ulId) \
            WinSetFocus(HWND_DESKTOP, WinWindowFromID(hwndDlg, ulId))

    #define winhQueryCnrInfo(hwndCnr, CnrInfo) \
            WinSendMsg(hwndCnr, CM_QUERYCNRINFO,  \
                    (MPARAM)&CnrInfo,             \
                    (MPARAM)sizeof(CnrInfo))

    #define winhCnrSelectRecord(hwndCnr, precc) \
            WinSendMsg(hwndCnr, CM_SETRECORDEMPHASIS, \
                    (MPARAM)precc, \
                    MPFROM2SHORT(TRUE, CRA_SELECTED))

    SHORT winhInsertMenuItem(HWND hwndMenu,
                             SHORT iPosition,

                             SHORT sItemId,
                             PSZ pszItemTitle,
                             SHORT afStyle,
                             SHORT afAttr);

    HWND winhInsertSubmenu(HWND hwndMenu,
                           ULONG iPosition,
                           SHORT sMenuId,
                           PSZ pszSubmenuTitle,
                           USHORT afMenuStyle,

                           SHORT sItemId,

                           PSZ pszItemTitle,
                           USHORT afItemStyle,
                           USHORT afAttribute);

    SHORT winhInsertMenuSeparator(HWND hMenu,
                                  SHORT iPosition,
                                  SHORT sId);

    VOID winhMenuRemoveEllipse(HWND hwndMenu,
                               USHORT usItemId);

    VOID winhSetDlgItemSpinData(HWND hwndDlg,
                               ULONG idSpinButton,
                               ULONG min,
                               ULONG max,
                               ULONG current);

    LONG winhAdjustDlgItemSpinData(HWND hwndDlg,
                                   USHORT usItemID,
                                   LONG lGrid,
                                   USHORT usNotifyCode);

    ULONG winhCnrScrollToRecord(HWND hwndCnr, PRECORDCORE pRec,
                                ULONG fsExtent, BOOL KeepParent);

    PRECORDCORE winhCnrAllocRecord(HWND hwndCnr, ULONG cbrecc);

    PRECORDCORE winhCnrInsertRecord(HWND hwndCnr, PRECORDCORE preccParent, PRECORDCORE precc,
                PSZ pszText, ULONG flRecordAttr);

    BOOL winhSaveWindowPos(HWND hwnd,
                           HINI hIni,
                           PSZ pszApp,
                           PSZ pszKey);

    BOOL winhRestoreWindowPos(HWND hwnd,
                           HINI hIni,
                           PSZ pszApp,
                           PSZ pszKey,
                           ULONG fl);

    void winhCenterWindow(HWND hwnd);

    ULONG winhCenteredDlgBox(HWND hwndParent, HWND hwndOwner,
                  PFNWP pfnDlgProc, HMODULE hmod, ULONG idDlg, PVOID pCreateParams);

    LONG winhQueryPresColor(HWND hwnd,
                            ULONG ulPP,
                            PSZ pszKeyName,
                            PSZ pszDefault);

    HWND winhCreateFakeDesktop(HWND hwndSibling);

    HWND winhQueryCnrFromFrame(HWND hwndFrame);

    BOOL winhAssertWarp4Notebook(HWND hwndDlg,
                        USHORT usIdThreshold,    // in: ID threshold
                        ULONG ulDownUnits);      // in: dialog units or 0

    SHORT winhQueryItemUnderMouse(HWND hwndMenu, POINTL *pptlMouse, RECTL *prtlItem);

    ULONG winhDrawFormattedText(HPS hps, PRECTL prcl, PSZ pszText, ULONG flCmd);

    VOID winhKillTasklist(VOID);

    ULONG winhQueryPendingSpoolJobs(VOID);

#endif

#if __cplusplus
}
#endif

